import './Password.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {Password} from '@components/Password';
import {Title} from '@components/Title';
import {Description} from '@components/Description';
import {Button} from '@components/Button';
import {FIELDS_NAMES} from '@components/Field/names';
import {classNames} from '@blocks/utils';
import metrika from '@blocks/metrics';

const b = classNames('PasswordSignUpInDaHouse');

class PasswordSignUp extends React.PureComponent {
    componentDidMount() {
        metrika.send('Показ экрана ввода пароля');
    }

    render() {
        const {onConfirm, login, buttonView, loading} = this.props;

        return (
            <div className={b('')}>
                <div className={b('head')}>
                    <Title>{i18n('_AUTH_.registration.step.password.title')}</Title>
                    <Description>{i18n('_AUTH_.registration.step.password.description')}</Description>
                </div>

                <div className={b('body')}>
                    <input
                        className={b('hidden-field')}
                        type='text'
                        name={FIELDS_NAMES.LOGIN}
                        id='login'
                        readOnly={true}
                        autoComplete='username'
                        value={login}
                    />
                    <Password hideLabel={true} shouldValidate={true} view='big-input' size='l' />
                </div>

                <div className={b('controls')}>
                    <Button
                        onClick={onConfirm}
                        text={i18n('_AUTH_.next')}
                        width='max'
                        size='l'
                        disabled={loading}
                        type='submit'
                        view={buttonView}
                    />
                </div>
            </div>
        );
    }
}

PasswordSignUp.propTypes = {
    onConfirm: PropTypes.func.isRequired,
    goBack: PropTypes.func,
    place: PropTypes.string,
    login: PropTypes.string,
    loading: PropTypes.bool,
    buttonView: PropTypes.string
};

export {PasswordSignUp as Password};
