import {connect} from 'react-redux';
import {Password} from './Password.jsx';
import {getFormValues} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const {auth = {}, customs = {}} = state;
    const {loading} = auth;

    return {
        login: getFormValues(state).login,
        loading,
        buttonView: customs.buttonView
    };
};

const ConnectedPassword = connect(mapStateToProps)(Password);

export {ConnectedPassword as Password};
