import './CallBack.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {AccountsListItem} from '@components/AccountsListItem';
import {Title} from '@components/Title';

const b = cn('CallBack');

class CallBack extends React.PureComponent {
    form = React.createRef();

    state = {
        uid: ''
    };

    onAccountClick = ({event, account = {}}) => {
        event.preventDefault();
        const {uid} = account;

        this.setState({uid}, () => {
            this.form.current && this.form.current.submit();
        });
    };

    renderAccounts = () => {
        const {mode, accounts = []} = this.props;
        const {uid} = this.state;

        if (mode !== 'choose') {
            return null;
        }

        return (
            <React.Fragment>
                <input type='hidden' name='uid' value={uid} />
                {accounts.map((account) => (
                    <AccountsListItem
                        account={account}
                        onClick={this.onAccountClick}
                        key={`account-${account.login}`}
                    />
                ))}
            </React.Fragment>
        );
    };

    render() {
        const {consumer, trackId, action} = this.props;

        return (
            <form action={action} method='post' ref={this.form}>
                <input type='hidden' name='consumer' value={consumer} />
                <input type='hidden' name='track_id' value={trackId} />
                <div className={b()}>
                    <div className={b('head')}>
                        <Title size='m'>{i18n('Frontend.social.callback.title')}</Title>
                    </div>

                    <div className={b('body')}>{this.renderAccounts()}</div>
                </div>
            </form>
        );
    }
}

CallBack.propTypes = {
    consumer: PropTypes.string.isRequired,
    trackId: PropTypes.string.isRequired,
    action: PropTypes.string.isRequired,
    mode: PropTypes.string.isRequired,
    accounts: PropTypes.arrayOf(
        PropTypes.shape({
            login: PropTypes.string.isRequired,
            display_name: {
                name: PropTypes.string.isRequired
            }
        })
    )
};

export {CallBack};
