import {connect} from 'react-redux';
import {CallBack} from './CallBack.jsx';
import {getTrackId} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const {social = {}} = state;
    const {mode, accounts = [], consumer, action} = social;

    return {
        accounts,
        mode,
        trackId: getTrackId(state, 'social'),
        consumer,
        action
    };
};

const ConnectedCallBack = connect(mapStateToProps)(CallBack);

export {ConnectedCallBack as CallBack};
