import './Error.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Title} from '@components/Title';
import {Description} from '@components/Description';
import {Button} from '@components/Button';

const b = cn('SocialError');

class Error extends React.PureComponent {
    goToMagic = () => {
        const {login} = this.props;
        const href = `/auth?mode=qr&login=${login}`;
        const params = {
            status: 'ok',
            socialAuth: true,
            goToMagic: true,
            login
        };

        if (window.opener) {
            try {
                window.opener.postMessage(params, location.origin);
                window.close();
            } catch (error) {
                window.opener.location = href;
            }
        } else {
            location.href = href;
        }
    };

    getLink = () => {
        const {linkToMagic, retpath} = this.props;

        return linkToMagic || retpath;
    };

    onButtonClick = (event) => {
        const {goToMagic, isInsufficientData, isAccountDisabled, needChangePass} = this.props;

        if (isInsufficientData || isAccountDisabled || goToMagic || needChangePass) {
            event.preventDefault();
        }

        if (goToMagic) {
            return this.goToMagic();
        }

        window.close();
    };

    render() {
        const {title, description, buttonText, isMobile} = this.props;

        return (
            <div className={b()}>
                <div className={b('head')}>
                    <Title size='m'>{title}</Title>
                </div>

                <div className={b('body')}>
                    <Description theme='grey'>
                        <span dangerouslySetInnerHTML={{__html: description}} />
                    </Description>
                </div>

                <div className={b('controls')}>
                    <Button
                        type='link'
                        size='l'
                        url={this.getLink()}
                        onClick={this.onButtonClick}
                        text={buttonText}
                        width={isMobile ? 'max' : 'auto'}
                    />
                </div>
            </div>
        );
    }
}

Error.propTypes = {
    title: PropTypes.string.isRequired,
    description: PropTypes.string,
    buttonText: PropTypes.string,
    linkToMagic: PropTypes.string,
    needChangePass: PropTypes.bool,
    goToMagic: PropTypes.bool,
    isAccountDisabled: PropTypes.bool,
    isMobile: PropTypes.bool,
    isInsufficientData: PropTypes.bool,
    retpath: PropTypes.string,
    login: PropTypes.string
};

export {Error};
