import {connect} from 'react-redux';
import {Error} from './Error.jsx';
import {isMobile} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const {social = {}} = state;
    const {
        title,
        description,
        buttonText,
        login,
        linkToMagic,
        needChangePass,
        retpath,
        goToMagic,
        isAccountDisabled,
        isInsufficientData
    } = social;

    return {
        title,
        description,
        buttonText,
        linkToMagic,
        needChangePass,
        retpath,
        goToMagic,
        login,
        isAccountDisabled,
        isInsufficientData,
        isMobile: isMobile(state)
    };
};

const ConnectedError = connect(mapStateToProps)(Error);

export {ConnectedError as Error};
