import React from 'react';
import PropTypes from 'prop-types';
import {Spin} from '@components/Spin';
import {storageAvailable} from '@blocks/utils';

class InitSuggest extends React.PureComponent {
    componentDidMount() {
        const {suggest} = this.props;

        if (storageAvailable('localStorage')) {
            localStorage.setItem('socialResponse', JSON.stringify({socialSuggest: true, suggest}));
        } else {
            document.cookie = `socialParams=${suggest.trackId};path=/;max-age=${60 * 60 * 0.5}`;
            document.cookie = `process=socialSuggest;path=/;max-age=${60 * 60 * 0.5}`;
        }

        try {
            if (window.opener === null) {
                if (storageAvailable('localStorage')) {
                    localStorage.setItem('process', 'socialSuggest');
                }

                window.location.replace(`${window.location.origin}/auth`);
                return;
            }

            window.close();
        } catch (error) {
            // TODO экран с ошибкой
            // console.error('error', error);
        }
    }

    render() {
        return <Spin progress={true} view='default' size='l' position='center' />;
    }
}

InitSuggest.propTypes = {
    suggest: PropTypes.shape({
        accounts: PropTypes.array,
        authRetpath: PropTypes.string,
        authTrackId: PropTypes.string,
        taskId: PropTypes.string,
        trackId: PropTypes.string
    })
};

export {InitSuggest};
