import React from 'react';
import PropTypes from 'prop-types';
import {Spin} from '@components/Spin';

class Redirector extends React.PureComponent {
    componentDidMount() {
        const {location} = this.props;

        if (location) {
            return (window.location = location);
        }
    }

    render() {
        return <Spin progress={true} view='default' size='l' position='center' />;
    }
}

Redirector.propTypes = {
    location: PropTypes.string.isRequired
};

export {Redirector};
