import './Register.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Title} from '@components/Title';
import {Button} from '@components/Button';
import {AccountsListItem} from '@components/AccountsListItem';
import {CaptchaWithField} from '@components/CaptchaWithField';
import {Description} from '@components/Description';
import {getError} from '@blocks/utils';

const b = cn('Register');

class Register extends React.PureComponent {
    form = React.createRef();

    onClick = () => {
        const {isCaptchaRequired, captchaValue, updateErrors} = this.props;

        if (isCaptchaRequired && !captchaValue) {
            return updateErrors({field: 'captcha', error: getError('captcha', 'missingvalue')});
        }

        this.form.current && this.form.current.submit();
    };

    render() {
        const {consumer, trackId, action, profile, isCaptchaRequired, eulaTexts, isMobile} = this.props;
        const {description, button} = eulaTexts;

        return (
            <form action={action} method='post' ref={this.form}>
                <input type='hidden' name='consumer' value={consumer} />
                <input type='hidden' name='track_id' value={trackId} />
                <input type='hidden' value='yes' checked='checked' name='eula_accepted' />
                <div className={b()}>
                    <div className={b('head')}>
                        <Title size='m'>{i18n('_AUTH_.social.register.title')}</Title>
                    </div>

                    <div className={b('body')}>
                        <div className={b('profile')}>
                            <AccountsListItem isStatic={true} account={profile} />
                        </div>

                        {isCaptchaRequired && <CaptchaWithField />}

                        <Description theme='grey'>
                            <div dangerouslySetInnerHTML={{__html: description}} />
                        </Description>
                    </div>

                    <div className={b('controls')}>
                        <Button
                            text={button}
                            type='button'
                            size='l'
                            onClick={this.onClick}
                            width={isMobile ? 'max' : 'auto'}
                        />
                    </div>
                </div>
            </form>
        );
    }
}

Register.propTypes = {
    consumer: PropTypes.string.isRequired,
    trackId: PropTypes.string.isRequired,
    action: PropTypes.string.isRequired,
    profile: PropTypes.shape({
        login: PropTypes.string,
        name: PropTypes.string
    }).isRequired,
    isCaptchaRequired: PropTypes.bool,
    isMobile: PropTypes.bool,
    eulaTexts: PropTypes.shape({
        title: PropTypes.string,
        description: PropTypes.string,
        button: PropTypes.string
    }).isRequired,
    captchaValue: PropTypes.string,
    updateErrors: PropTypes.func
};

export {Register};
