import {connect} from 'react-redux';
import {Register} from './Register.jsx';
import {getTrackId, getEULATexts, getFormValues, isMobile} from '@blocks/selectors';
import {updateErrors} from '@blocks/actions/form';

const mapStateToProps = (state = {}) => {
    const {social = {}} = state;
    const {consumer, action, profile = {}, isCaptchaRequired} = social;
    const values = getFormValues(state);

    return {
        trackId: getTrackId(state, 'social'),
        consumer,
        action,
        profile,
        isCaptchaRequired,
        eulaTexts: getEULATexts(state),
        captchaValue: values.captcha,
        isMobile: isMobile(state)
    };
};

const mapDispathToProps = {
    updateErrors
};

const ConnectedRegister = connect(mapStateToProps, mapDispathToProps)(Register);

export {ConnectedRegister as Register};
