import './Auth.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Title} from '@components/Title';
import {AccountsListItem} from '@components/AccountsListItem';
import {STATES} from '@screens/Social/Suggest/states';
import metrika from '@blocks/metrics';
import {SOCIAL} from '@blocks/authv2/metrics_constants';

const b = cn('SocialSuggestAuth');

export class Auth extends React.PureComponent {
    componentDidMount() {
        metrika.send([SOCIAL, 'Показ экрана выбор аккаунта из списка']);
    }

    onAccountClick = (params = {}) => {
        const {multiStepAuthStart} = this.props;
        const {account, event} = params;
        const {uid, originalLogin} = account;

        if (uid) {
            event && event.preventDefault();
            multiStepAuthStart({login: originalLogin, isAuthFromSocialSuggest: true});
            metrika.send([SOCIAL, 'Выбор аккаунта из списка']);
        }
    };

    switchToModeRegisterSocial = () => {
        const {changeState, setCaptchaTrack, registerSocialTrackId} = this.props;

        setCaptchaTrack(registerSocialTrackId);
        changeState({state: STATES.REGISTER_SOCIAL});
        metrika.send([SOCIAL, 'Cоздать новый аккаунт']);
    };

    render() {
        const {accounts = [], canRegisterSocial} = this.props;

        return (
            <div className={b()}>
                <div className={b('head')}>
                    <Title>{i18n('_AUTH_.social-accounts-suggest.title')}</Title>
                </div>

                <div className={b('body')}>
                    {accounts.map((account) => (
                        <AccountsListItem
                            account={account}
                            key={`account-${account.uid}`}
                            testKey={`accounts:item-${account.uid}`}
                            onClick={this.onAccountClick}
                        />
                    ))}

                    {canRegisterSocial && (
                        <AccountsListItem
                            isButton={true}
                            text={i18n('_AUTH_.registration.btn.createnew')}
                            key={'account-create'}
                            testKey={'accounts:item-create'}
                            onClick={this.switchToModeRegisterSocial}
                        />
                    )}
                </div>
            </div>
        );
    }
}

Auth.propTypes = {
    state: PropTypes.oneOf(['auth', 'register-lite', 'register-social']),
    multiStepAuthStart: PropTypes.func.isRequired,
    changeState: PropTypes.func.isRequired,
    accounts: PropTypes.arrayOf(
        PropTypes.shape({
            default_avatar: PropTypes.string.isRequired,
            display_name: {
                name: PropTypes.string.isRequired
            },
            login: PropTypes.string.isRequired
        })
    ),
    canRegisterSocial: PropTypes.bool,
    setCaptchaTrack: PropTypes.func.isRequired,
    registerSocialTrackId: PropTypes.string.isRequired
};
