import {connect} from 'react-redux';
import {Auth} from './Auth.jsx';
import multiStepAuthStart from '@blocks/authv2/actions/multiStepAuthStart';
import {changeState} from '@blocks/authv2/actions/socialSuggest';
import {setCaptchaTrack} from '@components/Captcha/actions';

const mapStatToProps = (state = {}) => {
    const {socialSuggest = {}} = state;
    const {accounts, canRegisterSocial, registerSocialTrackId} = socialSuggest;

    return {accounts, canRegisterSocial, registerSocialTrackId};
};

const mapDispatchToProps = {
    multiStepAuthStart,
    changeState,
    setCaptchaTrack
};

const ConnectedAuth = connect(mapStatToProps, mapDispatchToProps)(Auth);

export {ConnectedAuth as Auth};
