import './RegisterLite.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Title} from '@components/Title';
import {GlobalError} from '@screens/GlobalError';
import {Spin} from '@components/Spin';
import {Description} from '@components/Description';
import {Button} from '@components/Button';
import {Icon} from '@components/Icon';
import {Link} from '@components/Link';
import {Field, FIELDS_NAMES} from '@components/Field';
import metrika from '@blocks/metrics';
import {SOCIAL} from '@blocks/authv2/metrics_constants';

const b = cn('SocialSuggestRegisterLite');

export class RegisterLite extends React.PureComponent {
    componentWillUnmount() {
        const {clearForm, clearState} = this.props;

        clearForm();
        clearState();
    }

    componentDidMount() {
        const {getRegisterLiteState} = this.props;

        getRegisterLiteState();
        metrika.send([SOCIAL, 'Показ экрана регистрации лайта']);
    }

    changeFIO = () => {
        const {setEditFormState} = this.props;

        setEditFormState();
        metrika.send([SOCIAL, 'Изменить персональные данные']);
    };

    onRegisterButtonClick = (event) => {
        const {registerLite} = this.props;

        event.preventDefault();
        registerLite();
    };

    getRegistrationForm = () => {
        const {eulaTexts, registerLiteState = {}, isChangeFIO} = this.props;
        const {socialProviderCode, socialProviderName, email, firstname, lastname} = registerLiteState;
        const {description, button} = eulaTexts;

        return (
            <form onSubmit={this.onRegisterButtonClick} className={b()}>
                <div className={b('head')}>
                    <Title>{i18n('_AUTH_.social-accounts-register-lite.title')}</Title>
                </div>

                <div className={b('body')}>
                    {socialProviderCode && (
                        <div className={b('info-raw')} data-t='social-suggest-register-lite-provider-name'>
                            <div className={b('info')}>
                                <div className={b('label')}>
                                    {i18n('_AUTH_.social-accounts-register-lite.field.label.social')}
                                </div>
                                {socialProviderName}
                            </div>
                            <div className={b('control')}>
                                <Icon type={socialProviderCode} size='m' />
                            </div>
                        </div>
                    )}

                    {email && (
                        <div className={b('info-raw')} data-t='social-suggest-register-lite-email'>
                            <div className={b('info')}>
                                <div className={b('label')}>
                                    {i18n('_AUTH_.social-accounts-register-lite.field.label.email')}
                                </div>
                                {email}
                            </div>
                        </div>
                    )}

                    {!isChangeFIO && firstname && lastname ? (
                        <div className={b('info-raw', {offset: 'l'})} data-t='social-suggest-register-lite-fio'>
                            <div className={b('info')}>
                                <div className={b('label')}>
                                    {i18n('_AUTH_.social-accounts-register-lite.field.label.fio')}
                                </div>
                                {firstname && lastname ? `${firstname} ${lastname}` : firstname ? firstname : lastname}
                            </div>

                            <div className={b('control')}>
                                <Link dataT='change' pseudo={true} onClick={this.changeFIO}>
                                    {i18n('_AUTH_.change')}
                                </Link>
                            </div>
                        </div>
                    ) : (
                        <div className={b('edit-fio')}>
                            <Field size='l' view='floating-label' name={FIELDS_NAMES.FIRSTNAME} shouldValidate={true} />
                            <Field size='l' view='floating-label' name={FIELDS_NAMES.LASTNAME} shouldValidate={true} />
                        </div>
                    )}
                </div>

                <div className={b('controls')}>
                    <div className={b('eula')}>
                        <Description theme='grey' dataT='eula' size='s' position='left'>
                            <div dangerouslySetInnerHTML={{__html: description}} />
                        </Description>
                    </div>

                    <Button
                        onClick={this.onRegisterButtonClick}
                        text={button}
                        type='submit'
                        size='l'
                        width='max'
                        progress={false}
                        dataT='register-button'
                    />
                </div>
            </form>
        );
    };

    getLoader = () => {
        return (
            <div className={b('loader')}>
                <Spin size='l' position='center' progress={true} />
            </div>
        );
    };

    getBody() {
        const {registerLiteState = {}} = this.props;
        const {status} = registerLiteState;

        if (status === 'error') {
            return <GlobalError error={registerLiteState} />;
        }

        if (status === 'ok') {
            return this.getRegistrationForm();
        }

        return this.getLoader();
    }

    render() {
        return <div className={b()}>{this.getBody()}</div>;
    }
}

RegisterLite.propTypes = {
    eulaTexts: PropTypes.shape({
        title: PropTypes.string,
        description: PropTypes.string,
        button: PropTypes.string
    }).isRequired,
    isChangeFIO: PropTypes.bool,
    clearForm: PropTypes.func.isRequired,
    clearState: PropTypes.func.isRequired,
    registerLite: PropTypes.func.isRequired,
    setEditFormState: PropTypes.func.isRequired,
    getRegisterLiteState: PropTypes.func.isRequired,
    registerLiteState: PropTypes.shape({
        status: PropTypes.oneOf(['error', 'ok'])
    })
};
