import {connect} from 'react-redux';
import {RegisterLite} from './RegisterLite.jsx';
import {getRegisterLiteState, registerLite, clearState, setEditFormState} from '@blocks/authv2/actions/socialSuggest';
import {clearForm} from '@blocks/actions/form';
import {getEULATexts, getSocialName} from '@blocks/selectors';

const mapStatToProps = (state = {}) => {
    const {socialSuggest = {}} = state;
    const {registerLiteState = {}, isChangeFIO} = socialSuggest;
    const {socialProviderCode} = registerLiteState;

    return {
        registerLiteState: {...registerLiteState, socialProviderName: getSocialName(socialProviderCode)},
        eulaTexts: getEULATexts(state),
        isChangeFIO
    };
};

const mapDispatchToProps = {
    getRegisterLiteState,
    registerLite,
    clearForm,
    clearState,
    setEditFormState
};

const ConnectedRegisterLite = connect(mapStatToProps, mapDispatchToProps)(RegisterLite);

export {ConnectedRegisterLite as RegisterLite};
