import './RegisterSocial.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Title} from '@components/Title';
import {AccountsListItem} from '@components/AccountsListItem';
import {CaptchaWithField} from '@components/CaptchaWithField';
import {Description} from '@components/Description';
import {Button} from '@components/Button';
import {GlobalError} from '@screens/GlobalError';
import {Field, FIELDS_NAMES} from '@components/Field';
import {TRACK_TYPES} from '@blocks/actions/tracks';
import metrika from '@blocks/metrics';
import {SOCIAL} from '@blocks/authv2/metrics_constants';
import {ServiceSubscriptionPermission} from '@components/ServiceSubscripionPermission';

const b = cn('SocialSuggestRegisterSocial');

class RegisterSocial extends React.PureComponent {
    componentDidMount() {
        metrika.send([SOCIAL, 'Показ экрана регистрации социальщика']);
    }

    componentWillUnmount() {
        const {clearForm, clearState} = this.props;

        clearForm();
        clearState();
    }

    maybeRenderFIOForm = () => {
        const {profile = {}, updateTrackId, registerSocialTrackId} = this.props;
        const {name} = profile;

        updateTrackId({id: registerSocialTrackId, type: TRACK_TYPES.REGISTER});

        if (name) {
            return false;
        }

        return (
            <div className={b('edit-fio')}>
                <Field size='l' view='floating-label' name={FIELDS_NAMES.FIRSTNAME} shouldValidate={true} />
                <Field size='l' view='floating-label' name={FIELDS_NAMES.LASTNAME} shouldValidate={true} />
            </div>
        );
    };

    maybeRenderProfile = () => {
        const {profile = {}} = this.props;
        const {login, name} = profile;

        if (!login && !name) {
            return false;
        }

        return (
            <div className={b('profile')}>
                <AccountsListItem isStatic={true} account={profile} />
            </div>
        );
    };

    render() {
        const {
            profile = {},
            isCaptchaRequired,
            eulaTexts,
            socialProviderName,
            registerSocial,
            registerSocialState
        } = this.props;
        const {status} = registerSocialState;
        const {description, button} = eulaTexts;
        const {provider} = profile;

        if (status === 'error') {
            return <GlobalError error={registerSocialState} />;
        }

        return (
            <div className={b()}>
                <div className={b('head')}>
                    <Title size='m'>
                        {provider
                            ? i18n('_AUTH_.social.register.title-with-provider', socialProviderName)
                            : i18n('_AUTH_.social.register.title')}
                    </Title>
                </div>

                <div className={b('body')}>
                    {this.maybeRenderProfile()}
                    {this.maybeRenderFIOForm()}

                    {isCaptchaRequired && (
                        <div className={b('captcha')}>
                            <CaptchaWithField />
                        </div>
                    )}
                </div>

                <div className={b('controls')}>
                    <div className={b('eula')}>
                        <Description theme='grey' dataT='eula' size='s' position='left'>
                            <div dangerouslySetInnerHTML={{__html: description}} />
                        </Description>
                        <ServiceSubscriptionPermission />
                    </div>

                    <Button view='action' size='l' text={button} type='button' width='max' onClick={registerSocial} />
                </div>
            </div>
        );
    }
}

RegisterSocial.propTypes = {
    profile: PropTypes.shape({
        login: PropTypes.string,
        provider: PropTypes.string.isRequired,
        name: PropTypes.string
    }),
    socialProviderName: PropTypes.string.isRequired,
    isCaptchaRequired: PropTypes.bool,
    eulaTexts: PropTypes.shape({
        title: PropTypes.string,
        description: PropTypes.string,
        button: PropTypes.string
    }).isRequired,
    registerSocial: PropTypes.func.isRequired,
    registerSocialState: PropTypes.shape({
        status: PropTypes.oneOf(['error', 'ok'])
    }),
    clearForm: PropTypes.func.isRequired,
    clearState: PropTypes.func.isRequired,
    updateTrackId: PropTypes.func.isRequired,
    registerSocialTrackId: PropTypes.string.isRequired
};

export {RegisterSocial};
