import {connect} from 'react-redux';
import {RegisterSocial} from './RegisterSocial';
import {getSocialName, getEULATexts} from '@blocks/selectors';
import {clearForm} from '@blocks/actions/form';
import {registerSocial, clearState} from '@blocks/authv2/actions/socialSuggest';
import {updateTrackId} from '@blocks/actions/tracks';

const mapStateToProps = (state) => {
    const {socialSuggest = {}} = state;
    const {profile = {}, isCaptchaRequired, registerSocialState, registerSocialTrackId} = socialSuggest;

    return {
        profile,
        isCaptchaRequired,
        registerSocialState,
        registerSocialTrackId,
        eulaTexts: getEULATexts(state),
        socialProviderName: getSocialName(profile.provider)
    };
};

const mapDispatchToProps = {
    registerSocial,
    clearState,
    clearForm,
    updateTrackId
};

const ConnectedRegisterSocial = connect(mapStateToProps, mapDispatchToProps)(RegisterSocial);

export {ConnectedRegisterSocial as RegisterSocial};
