import './Suggest.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {Auth} from './Screens/Auth';
import {RegisterLite} from './Screens/RegisterLite';
import {RegisterSocial} from './Screens/RegisterSocial';
import {STATES} from './states';

export const Suggest = ({state}) => {
    switch (state) {
        case STATES.AUTH: {
            return <Auth />;
        }

        case STATES.REGISTER_LITE: {
            return <RegisterLite />;
        }

        case STATES.REGISTER_SOCIAL: {
            return <RegisterSocial />;
        }

        default: {
            // TODO экран ошибки?
            return null;
        }
    }
};

Suggest.propTypes = {
    state: PropTypes.oneOf([STATES.REGISTER_SOCIAL, STATES.REGISTER_LITE, STATES.AUTH])
};
