import React, {useState} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {Input} from '@components/Input';

import {cn} from '@bem-react/classname';

import './Webauthn.styl';

const b = cn('Webauthn');

const renderButton = (text, onClick, arg) => (
    <div className={b('button')}>
        <Button width='max' type='button' view='action' size='l' onClick={() => onClick(arg)}>
            {text}
        </Button>
    </div>
);

const renderInput = (placeholder, value, onChange) => (
    <div className={b('input')}>
        <Input
            size='l'
            type='text'
            placeholder={placeholder}
            value={value}
            autoComplete='off'
            onChange={(e) => onChange(e.target.value)}
        />
    </div>
);

const renderSection = (title, blocks) => (
    <>
        <h2>{title}</h2>
        <hr />
        {blocks.map((block, i) => {
            return (
                <div key={i} className={b('block')}>
                    {block.input && renderInput(...block.input)}
                    {block.button && renderButton(...block.button)}
                </div>
            );
        })}
    </>
);

export const Webauthn = ({webauthnReg, webauthnAuth, webauthnRemove, webauthnList, confirmPhone, commitPhone}) => {
    const [deviceName, setDeviceName] = useState('');
    const [rmExtId, setRmExtId] = useState('');
    const [authExtId, setAuthExtId] = useState('');
    const [number, setNumber] = useState('');
    const [code, setCode] = useState('');

    return (
        <div className={b()}>
            {renderSection('Подтверждение телефона', [
                {input: ['phone_number', number, setNumber], button: ['Запросить код', confirmPhone, number]},
                {input: ['phone_code', code, setCode], button: ['Отправить код', commitPhone, code]}
            ])}
            {renderSection('Регистрация', [
                {
                    input: ['device_name', deviceName, setDeviceName],
                    button: ['Зарегистрироваться', webauthnReg, deviceName]
                }
            ])}
            {renderSection('Авторизация', [
                {input: ['auth_ext_id', authExtId, setAuthExtId], button: ['Авторизоваться', webauthnAuth, authExtId]}
            ])}
            {renderSection('Управление', [
                {button: ['Узнать список Webauthn', webauthnList]},
                {input: ['rm_ext_id', rmExtId, setRmExtId], button: ['Удалить Webauthn', webauthnRemove, rmExtId]}
            ])}
        </div>
    );
};

Webauthn.propTypes = {
    webauthnReg: PropTypes.func.isRequired,
    webauthnAuth: PropTypes.func.isRequired,
    confirmPhone: PropTypes.func.isRequired,
    commitPhone: PropTypes.func.isRequired,
    webauthnRemove: PropTypes.func.isRequired,
    webauthnList: PropTypes.func.isRequired
};
