/* eslint-disable no-console */

import {preformatMakeCredReq, preformatGetAssertReq, publicKeyCredentialToJSON} from './base64url-arraybuffer';
import api from '@blocks/api';
import {saveActionForRepeat} from '@blocks/common/actions';

function base64ToHex(str) {
    const encodedData = atob(str);

    let result = '';

    for (let i = 0; i < encodedData.length; i++) {
        const hex = encodedData.charCodeAt(i).toString(16);

        result += hex.length === 2 ? hex : `0${hex}`;
    }
    return result.toLowerCase();
}

export const webauthnReg = (deviceName) => (dispatch) => {
    dispatch(saveActionForRepeat(webauthnReg, deviceName));

    return api
        .request('/auth/webauthn/reg/submit')
        .done((response) => {
            console.log('/auth/webauthn/reg/submit response:', response);

            const publicKey = preformatMakeCredReq({...response.makeCredOptions});

            console.log('created publicKey:', publicKey);

            return navigator.credentials
                .create({publicKey})
                .then((response2) => {
                    console.log('navigator.credentials.create response:', response2);

                    const assertion = publicKeyCredentialToJSON(response2);

                    console.log('created assertion:', assertion);

                    while (assertion.response.attestationObject.length % 4 !== 0) {
                        assertion.response.attestationObject += '=';
                    }

                    while (assertion.response.clientDataJSON.length % 4 !== 0) {
                        assertion.response.clientDataJSON += '=';
                    }

                    return api
                        .request('/auth/webauthn/reg/commit', {
                            deviceName,
                            attestation: assertion.response.attestationObject,
                            client: assertion.response.clientDataJSON
                        })
                        .done((response) => {
                            console.log('/auth/webauthn/reg/commit response:', response);
                        })
                        .fail((error) => {
                            console.log('/auth/webauthn/reg/commit error:', error);
                        });
                })
                .catch((error) => {
                    console.log('navigator.credentials.create fail:', error);
                });
        })
        .fail((error) => {
            console.log('/auth/webauthn/reg/submit error response:', error);
        });
};

export const webauthnAuth = (extId) => (dispatch) => {
    dispatch(saveActionForRepeat(webauthnAuth, extId));

    return api
        .request('/auth/webauthn/auth/submit', {extId})
        .done((response) => {
            console.log('/auth/webauthn/auth/submit response:', response);

            if (response.status === 'failed') {
                console.log('status is failed !!! stop');
                return;
            }

            const publicKey = preformatGetAssertReq(response.assertion_options);

            console.log('created publicKey:', publicKey);

            return navigator.credentials
                .get({publicKey})
                .then((response2) => {
                    console.log('navigator.credential.get response', response2);

                    const assertion = publicKeyCredentialToJSON(response2);

                    console.log('created assertion:', assertion);

                    const {response: {authenticatorData, clientDataJSON, signature} = {}} = assertion;

                    return api
                        .request('/auth/webauthn/auth/commit', {
                            extId,
                            client: clientDataJSON,
                            auth: authenticatorData,
                            signature: base64ToHex(signature)
                        })
                        .done((response3) => {
                            console.log('/auth/webauthn/auth/commit response:', response3);
                        })
                        .fail((error) => {
                            console.log('/auth/webauthn/auth/commit error:', error);
                        });
                })
                .catch((error) => {
                    console.log('navigator.credential.get error:', error);
                });
        })
        .fail((error) => {
            console.log('/auth/webauthn/auth/submit error:', error);
        });
};

export const confirmPhone = (number) => (dispatch) => {
    const data = {
        mode: 'kek',
        number,
        display_language: 'ru'
    };

    dispatch(saveActionForRepeat(confirmPhone, number));

    return api.request('phone-confirm-code-submit', data);
};

export const commitPhone = (code) => (dispatch) => {
    const data = {
        code: code ? code.trim() : '',
        mode: 'kek'
    };

    dispatch(saveActionForRepeat(commitPhone, code));

    return api.request('phone-confirm-code', data);
};

export const webauthnRemove = (extId) => (dispatch) => {
    dispatch(saveActionForRepeat(webauthnRemove, extId));

    return api
        .request('/auth/webauthn/remove', {extId})
        .done((response) => {
            console.log('/auth/webauthn/remove response:', response);
        })
        .fail((error) => {
            console.log('/auth/webauthn/remove error:', error);
        });
};

export const webauthnList = () => (dispatch) => {
    dispatch(saveActionForRepeat(webauthnList));

    return api
        .request('/auth/webauthn/list')
        .done((response) => {
            console.log('/auth/webauthn/list response:', response);
        })
        .fail((error) => {
            console.log('/auth/webauthn/list error:', error);
        });
};
