/* eslint-disable-next-line compat/compat */
const createUintArray = (...args) => new Uint8Array(...args);

const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_';

// Use a lookup table to find the index.
const lookup = createUintArray(256);

for (let i = 0; i < chars.length; i++) {
    lookup[chars.charCodeAt(i)] = i;
}

const encode = (buffer) =>
    window.btoa(createUintArray(buffer).reduce((acc, byte) => acc + String.fromCharCode(byte), ''));

export const decode = function(base64string) {
    let p = 0;

    const bytes = createUintArray(base64string.length * 0.75);

    for (let i = 0; i < base64string.length; i += 4) {
        const encoded1 = lookup[base64string.charCodeAt(i)];
        const encoded2 = lookup[base64string.charCodeAt(i + 1)];
        const encoded3 = lookup[base64string.charCodeAt(i + 2)];
        const encoded4 = lookup[base64string.charCodeAt(i + 3)];

        bytes[p++] = (encoded1 << 2) | (encoded2 >> 4);
        bytes[p++] = ((encoded2 & 15) << 4) | (encoded3 >> 2);
        bytes[p++] = ((encoded3 & 3) << 6) | (encoded4 & 63);
    }

    return bytes.buffer;
};

export const preformatMakeCredReq = (makeCredReq) => {
    makeCredReq.challenge = decode(makeCredReq.challenge);
    makeCredReq.user.id = decode(makeCredReq.user.id);

    return makeCredReq;
};

export const preformatGetAssertReq = (getAssert) => {
    getAssert.challenge = decode(getAssert.challenge);

    for (const allowCred of getAssert.allowCredentials) {
        allowCred.id = decode(allowCred.id);
    }

    return getAssert;
};

export const publicKeyCredentialToJSON = (pubKeyCred) => {
    if (pubKeyCred instanceof Array) {
        return pubKeyCred.map((item) => publicKeyCredentialToJSON(item));
    }

    if (pubKeyCred instanceof ArrayBuffer) {
        return encode(pubKeyCred);
    }

    if (pubKeyCred instanceof Object) {
        const obj = {};

        for (const key in pubKeyCred) {
            obj[key] = publicKeyCredentialToJSON(pubKeyCred[key]);
        }

        return obj;
    }

    return pubKeyCred;
};
