import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {STEP_SCREENS} from './screens';

import './Security.styl';

const b = cn('Security');

export class Security extends PureComponent {
    getCurrentScreen = () => {
        const {step} = this.props;
        const CurrentScreen = STEP_SCREENS[step];

        return <CurrentScreen />;
    };

    render() {
        return (
            <div className={b('wrap')}>
                <div className={b('layout')}>
                    <h1 className='visually-hidden'>{i18n('ProfileSecurity.profile.security.page-title')}</h1>
                    {this.getCurrentScreen()}
                </div>
            </div>
        );
    }
}

Security.propTypes = {
    step: PropTypes.string.isRequired
};
