import api from '@blocks/api';
import {TRACK_TYPES} from '@blocks/actions/tracks';
import {getTrackId} from '@blocks/selectors';
import {STEPS} from '@blocks/Security/config';
import {updateAccountInfo, setNextStep} from '@blocks/Security/actions';
import {changeLoadingStatus} from '@blocks/actions/spin';

export function getUpdatedAccountInfo() {
    return function(dispatch, getState) {
        const state = getState();
        const {editEmails = {}, securityInfo = {}} = state;
        const {hasDeleteDone} = editEmails;
        const {step} = securityInfo;

        dispatch(changeLoadingStatus(true));
        api.request('update-account-info', {
            track_id: getTrackId(state, TRACK_TYPES.COMMON),
            mode: 'updateAccountInfo'
        })
            .done((response = {}) => {
                if (response.status === 'ok') {
                    dispatch(updateAccountInfo(response.info));

                    if (hasDeleteDone && step === 'emailEdit') {
                        return dispatch(setNextStep(STEPS.EMAIL));
                    }

                    dispatch(setNextStep(STEPS.FINISH));
                }
            })
            .always(() => {
                dispatch(changeLoadingStatus(false));
            });
    };
}
