import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {SCREENS_TYPES, STEPS} from '@blocks/Security/config';
import {EmailConfirm} from './EmailConfirm';
import {EmailAdd} from './EmailAdd';
import {cn} from '@bem-react/classname';
import './Email.styl';

const b = cn('Email');

export class Email extends PureComponent {
    componentDidMount() {
        const {setPrevStep, setScreenType, email} = this.props;

        setScreenType(SCREENS_TYPES.EMAIL);
        setPrevStep(email.length ? STEPS.EMAIL_EDIT : STEPS.EMAIL_ADD);
    }

    getEmailComponent = () => {
        const {email} = this.props;
        const EmailComponent = email.length ? EmailConfirm : EmailAdd;

        return <EmailComponent />;
    };

    render() {
        return (
            <main className={b('container')}>
                <div className={b('header')}>
                    <div className={b('headerIcon')} role='presentation' aria-hidden='true' />
                </div>
                {this.getEmailComponent()}
            </main>
        );
    }
}

Email.propTypes = {
    email: PropTypes.array.isRequired,
    setScreenType: PropTypes.func.isRequired,
    setPrevStep: PropTypes.func.isRequired
};
