import React, {Fragment, PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';

import {cn} from '@bem-react/classname';
import './EmailAdd.styl';
import {ConfigureEmail} from '@screens/ConfigureEmail';
import {STEPS} from '@blocks/Security/config';
import metrika from '@blocks/metrics';

const b = cn('EmailAdd');

export class EmailAdd extends PureComponent {
    componentDidMount() {
        metrika.send('Показ экрана c email, добавление адреса');
    }

    componentDidUpdate(prevProps) {
        if (!prevProps.hasCodeChecked && this.props.hasCodeChecked) {
            this.props.setNextStep(STEPS.STEP_RESULT);
            metrika.send('Экран c email, успешное добавление адреса');
        }
    }

    proceedToNextStep = () => {
        this.props.getUpdatedAccountInfo();
        metrika.send('Экран c email, кнопка "Следующий шаг"');
    };

    checkConfirmationCode = () => {
        this.props.checkConfirmationCode();
    };

    renderButtons = () => {
        const {hasCodeSent, isLoading} = this.props;

        if (hasCodeSent) {
            return (
                <Fragment>
                    <Button dataT='next-screen' size='l' view='clear' type='button' onClick={this.proceedToNextStep}>
                        {i18n('_AUTH_.common.cancel')}
                    </Button>
                    <Button
                        dataT='check-code-btn'
                        size='l'
                        view='action'
                        type='submit'
                        onClick={this.checkConfirmationCode}
                        progress={isLoading}
                    >
                        {i18n('ProfileSecurity.security.email_add_btn')}
                    </Button>
                </Fragment>
            );
        }

        return (
            <Button dataT='skip-btn' size='l' view='clear' type='button' onClick={this.proceedToNextStep}>
                {i18n('ProfileSecurity.skip_next.btn')}
            </Button>
        );
    };

    render() {
        const {title, descriptionText} = this.props;

        return (
            <>
                <div className={b('content')}>
                    <h2 className={b('title')}>{title}</h2>
                    <ConfigureEmail emailsList={[]} />
                    <div className={b('description')}>{descriptionText}</div>
                </div>
                <div className={b('footer')}>{this.renderButtons()}</div>
            </>
        );
    }
}

EmailAdd.propTypes = {
    email: PropTypes.string,
    setNextStep: PropTypes.func.isRequired,
    hasCodeChecked: PropTypes.bool,
    checkConfirmationCode: PropTypes.func.isRequired,
    getUpdatedAccountInfo: PropTypes.func.isRequired,
    hasCodeSent: PropTypes.bool.isRequired,
    title: PropTypes.string.isRequired,
    descriptionText: PropTypes.string.isRequired,
    isLoading: PropTypes.bool
};
