import {connect} from 'react-redux';
import {EmailAdd} from './EmailAdd.jsx';
import {setNextStep} from '@blocks/Security/actions';
import {getUpdatedAccountInfo} from '@blocks/Security/actions/getUpdatedAccountInfo';
import {checkConfirmationCode} from '@blocks/actions/editEmails';
import {getFormValues} from '@blocks/selectors';

const getTitle = (hasCodeSent = false) => {
    return hasCodeSent ? i18n('ProfileSecurity.security.email.check_title') : i18n('ProfileSecurity.email.add_title');
};
const getDescription = (hasCodeSent = false, email = '') => {
    return hasCodeSent
        ? i18n('ProfileSecurity.security.sent_email').replace('%email', email)
        : i18n('ProfileSecurity.email.add_description');
};

const mapStateToProps = (state = {}) => {
    const {editEmails = {}, isLoading} = state;
    const {hasCodeSent, hasCodeChecked} = editEmails;
    const formValues = getFormValues(state);

    return {
        email: formValues.email,
        hasCodeSent,
        hasCodeChecked,
        title: getTitle(hasCodeSent),
        descriptionText: getDescription(hasCodeSent, formValues.email),
        isLoading
    };
};

const mapDispatchToProps = {
    setNextStep,
    checkConfirmationCode,
    getUpdatedAccountInfo
};

const ConnectedEmailAdd = connect(mapStateToProps, mapDispatchToProps)(EmailAdd);

export {ConnectedEmailAdd as EmailAdd};
