import React, {Fragment, PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';

import {cn} from '@bem-react/classname';
import './EmailConfirm.styl';
import {STEPS} from '@blocks/Security/config';
import metrika from '@blocks/metrics';

const b = cn('EmailConfirm');

const ShowEmail = ({emails}) => {
    if (emails.length === 1) {
        return (
            <Fragment>
                <h2 className={b('title')}>{i18n('ProfileSecurity.email.confirmation_text_title')}</h2>
                <span className={b('emailAddress')}>{emails[0]}</span>
                <div className={b('description')}>
                    <p>{i18n('ProfileSecurity.email.confirmation_text')}</p>
                </div>
            </Fragment>
        );
    }

    return (
        <Fragment>
            <h2 className={b('title')}>{i18n('ProfileSecurity.email.confirmation_some_text_title')}</h2>
            <ul className={b('emailList')}>
                {emails.map((email, index) => (
                    <li className={b('emailAddress')} key={index}>
                        {email}
                    </li>
                ))}
            </ul>
            <div className={b('description')}>
                <p>{i18n('ProfileSecurity.email.confirmation_some_text')}</p>
            </div>
        </Fragment>
    );
};

ShowEmail.propTypes = {
    emails: PropTypes.array.isRequired
};

export class EmailConfirm extends PureComponent {
    componentDidMount() {
        metrika.send('Показ экрана c email, адрес привязан');
    }

    proceedToFormScreen = () => {
        this.props.setNextStep(STEPS.EMAIL_EDIT);
        metrika.send('Экран c email, кнопка "Изменить адрес"');
    };

    proceedToNextScreen = () => {
        this.props.getUpdatedAccountInfo();
        metrika.send('Экран c email, кнопка "Следующий шаг"');
    };

    render() {
        const {email} = this.props;

        return (
            <Fragment>
                <div className={b('content')}>
                    <ShowEmail emails={email} />
                </div>
                <div className={b('footer')}>
                    <Button
                        dataT='edit-email-btn'
                        size='l'
                        view='clear'
                        type='button'
                        onClick={this.proceedToFormScreen}
                    >
                        {email.length === 1
                            ? i18n('ProfileSecurity.email.edit_emails_btn')
                            : i18n('ProfileSecurity.email.edit_emails_some_btn')}
                    </Button>
                    <Button dataT='next-screen' size='l' view='action' type='button' onClick={this.proceedToNextScreen}>
                        {email.length === 1
                            ? i18n('ProfileSecurity.email.ok_btn')
                            : i18n('ProfileSecurity.email.ok_some_btn')}
                    </Button>
                </div>
            </Fragment>
        );
    }
}

EmailConfirm.propTypes = {
    email: PropTypes.array.isRequired,
    setNextStep: PropTypes.func.isRequired,
    getUpdatedAccountInfo: PropTypes.func.isRequired
};
