import {connect} from 'react-redux';
import {EmailConfirm} from './EmailConfirm.jsx';
import {setNextStep} from '@blocks/Security/actions';
import {getUpdatedAccountInfo} from '@blocks/Security/actions/getUpdatedAccountInfo';

const mapStateToProps = (state = {}) => {
    const {securityInfo = {}} = state;
    const {email} = securityInfo;

    return {
        email
    };
};

const mapDispatchToProps = {
    setNextStep,
    getUpdatedAccountInfo
};

const ConnectedEmailConfirm = connect(mapStateToProps, mapDispatchToProps)(EmailConfirm);

export {ConnectedEmailConfirm as EmailConfirm};
