import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {ConfigureEmail} from '@screens/ConfigureEmail';

import {cn} from '@bem-react/classname';
import './EmailEdit.styl';
import {STEPS} from '@blocks/Security/config';
import metrika from '@blocks/metrics';

const b = cn('EmailEdit');

export class EmailEdit extends PureComponent {
    componentDidMount() {
        this.props.clearEmailEditState();

        metrika.send('Показ экрана c email, редактирование адреса');
    }

    componentDidUpdate(prevProps) {
        const {hasCodeChecked, hasDeleteDone, getUpdatedAccountInfo, setNextStep} = this.props;

        if (!prevProps.hasCodeChecked && hasCodeChecked) {
            setNextStep(STEPS.STEP_RESULT);

            metrika.send('Экран редактирования email, успешная привязка');
        }

        if (!prevProps.hasDeleteDone && hasDeleteDone) {
            getUpdatedAccountInfo();
            metrika.send('Экран редактирования email, успешное удаление');
        }
    }

    cancelEdit = () => {
        this.props.setNextStep(STEPS.EMAIL);
        metrika.send('Экран редактирования email, кнопка "Отменить"');
    };

    completeAction = () => {
        const {hasCodeSent, emailsToDelete, deleteEmail, checkConfirmationCode} = this.props;

        if (hasCodeSent) {
            return checkConfirmationCode();
        }

        if (emailsToDelete.length) {
            return deleteEmail();
        }

        this.props.setNextStep(STEPS.EMAIL);
    };

    render() {
        const {hasCodeSent, email, emailEntered, isLoading} = this.props;

        return (
            <main className={b('container')}>
                <div className={b('header')}>
                    <div className={b('headerIcon')} role='presentation' aria-hidden='true' />
                </div>
                <div className={b('content')}>
                    <h2 className={b('title')}>{i18n('ProfileSecurity.security.email_edit_title')}</h2>
                    <ConfigureEmail emailsList={email} />
                    {hasCodeSent && (
                        <div className={b('description')}>
                            {i18n('ProfileSecurity.security.sent_email').replace('%email', emailEntered)}
                        </div>
                    )}
                </div>
                <div className={b('footer')}>
                    <Button dataT='cancel-btn' size='l' view='clear' type='button' onClick={this.cancelEdit}>
                        {i18n('_AUTH_.common.cancel')}
                    </Button>
                    <Button
                        dataT='continue-btn'
                        size='l'
                        view='action'
                        type='button'
                        onClick={this.completeAction}
                        progress={isLoading}
                    >
                        {i18n('Profile.common.continue')}
                    </Button>
                </div>
            </main>
        );
    }
}

EmailEdit.propTypes = {
    email: PropTypes.array.isRequired,
    emailEntered: PropTypes.string,
    emailsToDelete: PropTypes.array,
    hasCodeSent: PropTypes.bool.isRequired,
    hasCodeChecked: PropTypes.bool,
    hasDeleteDone: PropTypes.bool,
    setNextStep: PropTypes.func.isRequired,
    deleteEmail: PropTypes.func.isRequired,
    checkConfirmationCode: PropTypes.func.isRequired,
    clearEmailEditState: PropTypes.func.isRequired,
    getUpdatedAccountInfo: PropTypes.func.isRequired,
    isLoading: PropTypes.bool
};
