import {connect} from 'react-redux';
import {EmailEdit} from './EmailEdit.jsx';
import {setNextStep} from '@blocks/Security/actions';
import {checkConfirmationCode, deleteEmail, clearEmailEditState} from '@blocks/actions/editEmails';
import {getUpdatedAccountInfo} from '@blocks/Security/actions/getUpdatedAccountInfo';
import {getFormValues} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const {securityInfo = {}, editEmails = {}, isLoading} = state;
    const {hasCodeSent, hasCodeChecked, emailsToDelete, hasDeleteDone} = editEmails;
    const formValues = getFormValues(state);
    const {email} = securityInfo;

    return {
        email,
        emailEntered: formValues.email,
        hasCodeSent,
        hasCodeChecked,
        hasDeleteDone,
        emailsToDelete,
        isLoading
    };
};

const mapDispatchToProps = {
    checkConfirmationCode,
    deleteEmail,
    clearEmailEditState,
    setNextStep,
    getUpdatedAccountInfo
};

const ConnectedEmailEdit = connect(mapStateToProps, mapDispatchToProps)(EmailEdit);

export {ConnectedEmailEdit as EmailEdit};
