import {connect} from 'react-redux';
import {Email} from './Email.jsx';
import {setScreenType, setNextStep, setPrevStep} from '@blocks/Security/actions';

const mapStateToProps = (state = {}) => {
    const {securityInfo = {}} = state;
    const {email = []} = securityInfo;

    return {
        email
    };
};

const mapDispatchToProps = {
    setScreenType,
    setNextStep,
    setPrevStep
};

const ConnectedEmail = connect(mapStateToProps, mapDispatchToProps)(Email);

export {ConnectedEmail as Email};
