import {connect} from 'react-redux';
import {FinalScreen} from './FinalScreen.jsx';
import {setNextStep} from '@blocks/Security/actions';
import {getRedirectUrl, isMobile} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const {securityInfo = {}, common = {}} = state;
    const {securityLevel, password, phone, email = [], twoFAUrl, isNotMePage} = securityInfo;
    const redirectUrl = getRedirectUrl(state);

    return {
        securityLevel,
        phone,
        email,
        passwordStatus: password.status,
        passwordAge: password.age,
        profileUrl: common.defaultPage,
        isMobile: isMobile(state),
        redirectUrl,
        twoFAUrl,
        isNotMePage
    };
};

const mapDispatchToProps = {
    setNextStep
};

const ConnectedFinalScreen = connect(mapStateToProps, mapDispatchToProps)(FinalScreen);

export {ConnectedFinalScreen as FinalScreen};
