import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {cn} from '@bem-react/classname';
import './InfoScreen.styl';

const b = cn('InfoScreen');

export class InfoScreen extends Component {
    goToRetpath = () => {
        const {redirectUrl} = this.props;

        location.replace(redirectUrl);
    };

    render() {
        const {isMobile} = this.props;

        return (
            <main className={b('container')}>
                <div className={b('header')}>
                    <div className={b('headerIcon')} role='presentation' aria-hidden='true' />
                </div>
                <div className={b('content')}>
                    <h2 className={b('title')}>{i18n('ProfileSecurity.notme.advice_title')}</h2>
                    <div className={b('description')}>
                        <ul
                            className={b('descriptionList')}
                            dangerouslySetInnerHTML={{__html: i18n('ProfileSecurity.notme.advice_text')}}
                        />
                    </div>
                </div>
                <div className={b('footer')}>
                    <Button
                        dataT='goto-retpath-btn'
                        size='l'
                        width={isMobile ? 'max' : 'auto'}
                        view='action'
                        type='button'
                        onClick={this.goToRetpath}
                    >
                        {i18n('ProfileSecurity.security.step_final_btn')}
                    </Button>
                </div>
            </main>
        );
    }
}

InfoScreen.propTypes = {
    profileUrl: PropTypes.string,
    redirectUrl: PropTypes.string.isRequired,
    isMobile: PropTypes.bool
};
