import {connect} from 'react-redux';
import {InfoScreen} from './InfoScreen';
import {getRedirectUrl, isMobile} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const redirectUrl = getRedirectUrl(state);

    return {
        isMobile: isMobile(state),
        redirectUrl
    };
};

const ConnectedInfoScreen = connect(mapStateToProps)(InfoScreen);

export {ConnectedInfoScreen as InfoScreen};
