import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {cn} from '@bem-react/classname';
import {STEPS, SCREENS_TYPES} from '../../config';
import utils from '@blocks/utils';
import metrika from '@blocks/metrics';

import './Password.styl';

const b = cn('Password');

export class Password extends PureComponent {
    componentDidMount() {
        const {password} = this.props;
        const {setScreenType} = this.props;

        setScreenType(SCREENS_TYPES.PASSWORD);
        metrika.send(`Показ экрана пароля, статус пароля "${password.status}", "срок давности: ${password.age}"`);
    }

    getTexts = () => {
        const {helpLink, password} = this.props;
        const {status, updated, age} = password;
        const date = utils
            .dateToText(new Date(updated * 1000), {
                year: true,
                time: true
            })
            .toLowerCase();
        const texts = {
            ok: {
                title: i18n('ProfileSecurity.password_ok.title'),
                description: `${i18n('ProfileSecurity.profile.security.field-pwd_ok')} <br/> ${i18n(
                    'ProfileSecurity.profile.security.title_pwd-date'
                )} ${date}`
            },
            warning: {
                title: i18n('ProfileSecurity.password_warn.title'),
                description: i18n('ProfileSecurity.security.pwd_bad-text')
            },
            old: {
                title: i18n('ProfileSecurity.profile.security.title_pwd-old'),
                description: i18n('ProfileSecurity.profile.security.field-pwd_old').replace('%s', helpLink)
            },
            too_old: {
                title: i18n('ProfileSecurity.profile.security.title_pwd-toold'),
                description: i18n('ProfileSecurity.profile.security.field-pwd_toold').replace('%s', helpLink)
            }
        };

        return texts[age !== 'normal' ? age : status];
    };

    proceedToFormScreen = () => {
        this.props.setNextStep(STEPS.PASSWORD_FORM);
        metrika.send('Кнопка "Изменить пароль"');
    };

    proceedToNextScreen = () => {
        this.props.setNextStep(STEPS.PHONE);
        metrika.send('Кнопка "Следующая настройка"');
    };

    render() {
        const {password} = this.props;
        const {status} = password;
        const texts = this.getTexts();
        const isPwdOk = status === 'ok';

        return (
            <main className={b('container')}>
                <div className={b('header')}>
                    <div className={b('header-icon')} role='presentation' aria-hidden='true'>
                        <div className={b(`pwd-${status}`)} />
                    </div>
                </div>
                <div className={b('content')}>
                    <h2 className={b('title')}>{texts.title}</h2>
                    <div className={b('description')}>
                        <p dangerouslySetInnerHTML={{__html: texts.description}} />
                    </div>
                </div>
                <div className={b('footer')}>
                    <Button
                        dataT='change-password'
                        size='l'
                        view={isPwdOk ? 'clear' : 'action'}
                        type='button'
                        onClick={this.proceedToFormScreen}
                    >
                        {i18n('ProfileSecurity.security.change_pwd_btn')}
                    </Button>
                    <Button
                        dataT='next-screen'
                        size='l'
                        view={isPwdOk ? 'action' : 'clear'}
                        type='button'
                        onClick={this.proceedToNextScreen}
                    >
                        {i18n('ProfileSecurity.security.next_options_btn')}
                    </Button>
                </div>
            </main>
        );
    }
}

Password.propTypes = {
    setNextStep: PropTypes.func.isRequired,
    setScreenType: PropTypes.func.isRequired,
    password: PropTypes.string.isRequired,
    isMobile: PropTypes.bool,
    helpLink: PropTypes.string
};
