import {connect} from 'react-redux';
import {Password} from './Password.jsx';
import {setNextStep, setScreenType} from '../../actions/index';

const mapStateToProps = (state = {}) => {
    const {securityInfo = {}, settings = {}} = state;
    const {password} = securityInfo;

    return {
        password,
        helpLink: `https://yandex.${settings.tld || 'ru'}/support/passport/security.html`
    };
};

const mapDispatchToProps = {
    setNextStep,
    setScreenType
};

const ConnectedPassword = connect(mapStateToProps, mapDispatchToProps)(Password);

export {ConnectedPassword as Password};
