import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {ChangePassword} from '@screens/ChangePassword';
import {STEPS} from '../../config';
import {cn} from '@bem-react/classname';
import metrika from '@blocks/metrics';

import './PasswordForm.styl';

const b = cn('PasswordForm');

export class PasswordForm extends PureComponent {
    componentDidMount() {
        metrika.send('Экран смены пароля');
    }

    returnBack = () => {
        const {isNotMePage, setNextStep, clearForm} = this.props;

        if (isNotMePage) {
            setNextStep(STEPS.FINISH);
            return;
        }

        setNextStep(STEPS.PHONE);
        clearForm();
        metrika.send('Кнопка "отменить смену пароля"');
    };

    proceedChange = (event) => {
        if (event) {
            event.preventDefault();
        }
        this.props.changePassword();
    };

    componentDidUpdate(prevProps) {
        if (!prevProps.hasPasswordChanged && this.props.hasPasswordChanged) {
            this.props.setNextStep(STEPS.STEP_RESULT);
            metrika.send('Экран смены пароля: успешная смена пароля');
        }
    }

    render() {
        const {password, isLoading, isNotMePage} = this.props;
        const {status} = password;

        return (
            <form className={b('container')} method='post' action='#'>
                <div className={b('header')}>
                    <div className={b('header-icon')} role='presentation' aria-hidden='true'>
                        <div className={b(isNotMePage ? 'pwd-warning' : `pwd-${status}`)} />
                    </div>
                </div>
                <div className={b('content')}>
                    <h2 className={b('title')}>{i18n('ProfileSecurity.password.title')}</h2>
                    <div className={b('note')}>{i18n('ProfileSecurity.password.description')}</div>
                    <ChangePassword />
                </div>
                <div className={b('footer')}>
                    <Button
                        dataT='cancel-change-password'
                        size='l'
                        view='clear'
                        type='button'
                        onClick={this.returnBack}
                    >
                        {i18n('_AUTH_.cancel')}
                    </Button>
                    <Button
                        dataT='confirm-change-password'
                        size='l'
                        view='action'
                        type='submit'
                        onClick={this.proceedChange}
                        progress={isLoading}
                    >
                        {i18n('ProfileSecurity.security.change_pwd_btn')}
                    </Button>
                </div>
            </form>
        );
    }
}

PasswordForm.propTypes = {
    setNextStep: PropTypes.func.isRequired,
    changePassword: PropTypes.func.isRequired,
    clearForm: PropTypes.func.isRequired,
    login: PropTypes.string,
    password: PropTypes.object.isRequired,
    hasPasswordChanged: PropTypes.bool,
    isLoading: PropTypes.bool,
    isNotMePage: PropTypes.bool
};
