import {connect} from 'react-redux';
import {PasswordForm} from './PasswordForm.jsx';
import {setNextStep} from '../../actions';
import {clearForm} from '@blocks/actions/form';
import {changePasswordCommit} from '@blocks/actions/changePassword';

function mapStateToProps(state = {}) {
    const {securityInfo = {}, header = {}, changePassword = {}, isLoading} = state;
    const {defaultAccount = {}} = header;

    return {
        login: defaultAccount.login,
        password: securityInfo.password,
        hasPasswordChanged: changePassword.hasPasswordChanged,
        isNotMePage: securityInfo.isNotMePage,
        isLoading
    };
}

const mapDispatchToProps = {
    setNextStep,
    changePassword: changePasswordCommit,
    clearForm
};

const ConnectedPasswordForm = connect(mapStateToProps, mapDispatchToProps)(PasswordForm);

export {ConnectedPasswordForm as PasswordForm};
