import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {PhoneBind} from './PhoneBind';
import {PhoneChange} from './PhoneChange';
import {SCREENS_TYPES, STEPS} from '../../config';
import metrika from '@blocks/metrics';

import {cn} from '@bem-react/classname';
import './Phone.styl';

const b = cn('Phone');

export class Phone extends PureComponent {
    state = {
        isChangeForm: false
    };

    componentDidMount() {
        const {phone} = this.props;
        const {isChangeForm} = this.state;

        let metricsMessage = 'Показ экрана телефона, номер не привязан';

        this.props.getPhoneState();
        this.props.setScreenType(SCREENS_TYPES.PHONE);

        if (phone) {
            metricsMessage = 'Показ экрана телефона, номер привязан';
        }

        if (phone && isChangeForm) {
            metricsMessage = 'Показ экрана телефона, смена номера';
        }

        metrika.send(metricsMessage);
    }

    proceedToFormScreen = () => {
        this.setState((prevState) => ({
            isChangeForm: !prevState.isChangeForm
        }));
        this.props.setPhoneProcessType('replace');
    };

    proceedToNextScreen = () => {
        const {setNextStep} = this.props;

        setNextStep(STEPS.EMAIL);
        metrika.send('Экран телефона, кнопка "Следующий шаг"');
    };

    mayBeRenderDefault = () => {
        const {phone} = this.props;

        return (
            <main className={b('container')}>
                <div className={b('header')}>
                    <div className={b('headerIcon')} role='presentation' aria-hidden='true' />
                </div>
                <div className={b('content')}>
                    <h2 className={b('title')}>{i18n('ProfileSecurity.phone_confirm.title')}</h2>
                    <div className={b('number')}>{phone}</div>
                    <div className={b('description')}>{i18n('ProfileSecurity.phone_confirm.description')}</div>
                </div>

                <div className={b('footer')}>
                    <Button size='l' view='clear' type='button' onClick={this.proceedToFormScreen}>
                        {i18n('ProfileSecurity.phone.change_number')}
                    </Button>
                    <Button size='l' view='action' type='button' onClick={this.proceedToNextScreen}>
                        {i18n('ProfileSecurity.phone.confirm_number')}
                    </Button>
                </div>
            </main>
        );
    };

    render() {
        const {phone} = this.props;
        const {isChangeForm} = this.state;

        if (phone && isChangeForm) {
            return <PhoneChange />;
        }

        if (phone) {
            return this.mayBeRenderDefault();
        }

        return <PhoneBind />;
    }
}

Phone.propTypes = {
    phone: PropTypes.object,
    setNextStep: PropTypes.func.isRequired,
    setScreenType: PropTypes.func.isRequired,
    getPhoneState: PropTypes.func.isRequired,
    setPhoneProcessType: PropTypes.func.isRequired
};
