import React, {Fragment, PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {PhoneAdd} from '@screens/PhoneAdd';
import {STEPS} from '../../../config';
import metrika from '@blocks/metrics';

import {cn} from '@bem-react/classname';

import './PhoneBind.styl';

const b = cn('PhoneBind');

export class PhoneBind extends PureComponent {
    componentDidMount() {
        this.props.setNextStep(STEPS.PHONE_BIND);
    }

    componentDidUpdate(prevProps) {
        if (!prevProps.hasPhoneBound && this.props.hasPhoneBound) {
            this.props.setNextStep(STEPS.STEP_RESULT);
            metrika.send('Экран привязки номера телефона, успешное добавление номера');
        }
    }

    returnToForm = () => {
        const {updatePhoneInfo, cancelProcess} = this.props;

        cancelProcess();
        updatePhoneInfo({
            isInProgress: false,
            operationId: '',
            phoneId: '',
            hasCodeSent: false
        });
    };

    proceedToNextStep = () => {
        const {isInProgress} = this.props;

        if (isInProgress) {
            this.props.cancelProcess();
        }

        this.props.setNextStep(STEPS.EMAIL);
        metrika.send('Экран привязки номера телефона, кнопка "Следующий шаг"');
    };

    handleSubmit = (event) => {
        if (event) {
            event.preventDefault();
        }

        const {isInProgress, hasCodeSent, setPhoneProcessType, sendCode, phone, checkCode} = this.props;

        if (isInProgress || hasCodeSent) {
            return checkCode();
        }

        setPhoneProcessType('bind');
        sendCode(phone);
    };

    renderButtons = () => {
        const {isInProgress, hasCodeSent, isLoading} = this.props;

        if (hasCodeSent || isInProgress) {
            return (
                <Fragment>
                    <Button dataT='cancel-bind-phone' size='l' view='clear' type='button' onClick={this.returnToForm}>
                        {i18n('_AUTH_.cancel')}
                    </Button>
                    <Button
                        dataT='proceed-bind-phone'
                        size='l'
                        view='action'
                        type='submit'
                        onClick={this.handleSubmit}
                        progress={isLoading}
                    >
                        {i18n('ProfileSecurity.security.phone.bind_number')}
                    </Button>
                </Fragment>
            );
        }

        return (
            <Button dataT='next-screen' size='l' view='clear' type='button' onClick={this.proceedToNextStep}>
                {i18n('ProfileSecurity.security.next_options_btn')}
            </Button>
        );
    };

    getTitle = () => {
        const {hasCodeSent, isInProgress} = this.props;

        if (isInProgress) {
            return i18n('Phones.phones.init-operation.bind');
        }

        if (hasCodeSent) {
            return i18n('ProfileSecurity.phone.code_title');
        }

        return i18n('ProfileSecurity.phone.bind_title');
    };

    render() {
        return (
            <form className={b('container')} method='post' onSubmit={this.handleSubmit} action='#'>
                <div className={b('header')}>
                    <div className={b('headerIcon')} role='presentation' aria-hidden='true' />
                </div>
                <div className={b('content')}>
                    <h2 className={b('title')}>{this.getTitle()}</h2>
                    <PhoneAdd />
                </div>
                <div className={b('footer')}>{this.renderButtons()}</div>
            </form>
        );
    }
}

PhoneBind.propTypes = {
    phone: PropTypes.object,
    isInProgress: PropTypes.bool,
    isInQuarantine: PropTypes.bool,
    hasCodeSent: PropTypes.bool,
    hasCodeChecked: PropTypes.bool,
    hasPhoneBound: PropTypes.bool,
    setNextStep: PropTypes.func.isRequired,
    cancelProcess: PropTypes.func.isRequired,
    checkCode: PropTypes.func.isRequired,
    setPhoneProcessType: PropTypes.func.isRequired,
    sendCode: PropTypes.func.isRequired,
    updatePhoneInfo: PropTypes.func.isRequired,
    isLoading: PropTypes.bool
};
