import {connect} from 'react-redux';
import {PhoneBind} from './PhoneBind.jsx';
import {setNextStep} from '@blocks/Security/actions';
import {setPhoneProcessType, updatePhoneInfo} from '@blocks/actions/phone';
import {confirmCode, cancelProcess} from '@blocks/actions/phone/phoneProcess';
import {sendCode} from '@blocks/actions/phone/phoneBind';

const mapStateToProps = (state = {}) => {
    const {securityInfo = {}, phoneProcess = {}, isLoading} = state;
    const {phone} = securityInfo;
    const {isInProgress, isInQuarantine, hasCodeSent, hasCodeChecked} = phoneProcess;

    return {
        phone,
        isInProgress,
        isInQuarantine,
        hasCodeSent,
        hasCodeChecked,
        hasPhoneBound: hasCodeChecked && (isInProgress || hasCodeSent),
        isLoading
    };
};

const mapDispatchToProps = {
    setNextStep,
    checkCode: confirmCode,
    cancelProcess,
    sendCode,
    setPhoneProcessType,
    updatePhoneInfo
};

const ConnectedPhoneBind = connect(mapStateToProps, mapDispatchToProps)(PhoneBind);

export {ConnectedPhoneBind as PhoneBind};
