import React, {Fragment, PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {PhoneReplace} from '@screens/PhoneReplace';

import {cn} from '@bem-react/classname';
import metrika from '@blocks/metrics';

import './PhoneChange.styl';
import {STEPS} from '../../../config';

const b = cn('PhoneChange');

export class PhoneChange extends PureComponent {
    componentDidMount() {
        this.props.setNextStep('phoneChange');
    }

    componentDidUpdate(prevProps) {
        if (prevProps.phoneReplaceStatus === 'started' && this.props.phoneReplaceStatus === 'done') {
            this.props.setNextStep(STEPS.STEP_RESULT);
            metrika.send('Экран смены номера телефона, успешная смена');
        }
    }

    proceedToNextStep = () => {
        const {cancelReplace, setNextStep, isInProgress, isNotMePage} = this.props;
        const nextStep = isNotMePage ? STEPS.FINISH : STEPS.EMAIL;

        setNextStep(nextStep);

        if (isInProgress) {
            cancelReplace();
        }

        metrika.send('Экран смены номера телефона, кнопка "Следующий шаг"');
    };

    returnToForm = () => {
        const {updatePhoneInfo, cancelReplace} = this.props;

        cancelReplace();
        updatePhoneInfo({
            isInProgress: false,
            operationId: '',
            phoneId: '',
            hasCodeSent: false
        });
    };

    checkSmsCode = () => {
        this.props.checkCode();
    };

    renderButtons = () => {
        const {hasCodeSent, isInProgress, isLoading} = this.props;

        if (hasCodeSent || isInProgress) {
            return (
                <Fragment>
                    <Button size='l' view='clear' type='button' onClick={this.returnToForm}>
                        {i18n('_AUTH_.common.cancel')}
                    </Button>
                    <Button size='l' view='action' type='submit' onClick={this.checkSmsCode} progress={isLoading}>
                        {i18n('Profile.common.confirm')}
                    </Button>
                </Fragment>
            );
        }

        return (
            <Button size='l' view='clear' type='button' onClick={this.proceedToNextStep}>
                {i18n('_AUTH_.common.cancel')}
            </Button>
        );
    };

    render() {
        const {phone} = this.props;

        return (
            <main className={b('container')}>
                <div className={b('header')}>
                    <div className={b('headerIcon')} role='presentation' aria-hidden='true' />
                </div>
                <div className={b('content')}>
                    <h2 className={b('title')}>{i18n('ProfileSecurity.phone.add_new_title')}</h2>
                    <PhoneReplace phoneToChange={phone} />
                </div>
                <div className={b('footer')}>{this.renderButtons()}</div>
            </main>
        );
    }
}

PhoneChange.propTypes = {
    checkCode: PropTypes.func.isRequired,
    updatePhoneInfo: PropTypes.func.isRequired,
    setNextStep: PropTypes.func.isRequired,
    cancelReplace: PropTypes.func.isRequired,
    phone: PropTypes.string,
    hasCodeSent: PropTypes.bool,
    isInProgress: PropTypes.bool,
    phoneReplaceStatus: PropTypes.string,
    isLoading: PropTypes.bool,
    isNotMePage: PropTypes.bool
};
