import {connect} from 'react-redux';
import {PhoneChange} from './PhoneChange.jsx';
import {setNextStep} from '@blocks/Security/actions';
import {updatePhoneInfo} from '@blocks/actions/phone';
import {cancelProcess, confirmCode} from '@blocks/actions/phone/phoneProcess';

const mapStateToProps = (state = {}) => {
    const {securityInfo = {}, phoneProcess = {}, isLoading} = state;
    const {phone, isNotMePage} = securityInfo;
    const {hasCodeSent, isInProgress, phoneReplaceStatus} = phoneProcess;

    return {
        phone,
        hasCodeSent,
        phoneReplaceStatus,
        isInProgress,
        isLoading,
        isNotMePage
    };
};

const mapDispatchToProps = {
    setNextStep,
    cancelReplace: cancelProcess,
    checkCode: confirmCode,
    updatePhoneInfo
};

const ConnectedPhoneChange = connect(mapStateToProps, mapDispatchToProps)(PhoneChange);

export {ConnectedPhoneChange as PhoneChange};
