import {connect} from 'react-redux';
import {Phone} from './Phone.jsx';
import {setNextStep, setScreenType} from '../../actions';
import {setPhoneProcessType, getPhoneState} from '@blocks/actions/phone';

const mapStateToProps = (state = {}) => {
    const {securityInfo = {}} = state;
    const {phone, email = []} = securityInfo;

    return {
        phone,
        email
    };
};

const mapDispatchToProps = {
    setNextStep,
    setScreenType,
    getPhoneState,
    setPhoneProcessType
};

const ConnectedPhone = connect(mapStateToProps, mapDispatchToProps)(Phone);

export {ConnectedPhone as Phone};
