import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {cn} from '@bem-react/classname';
import {STEPS} from '@blocks/Security/config';

import './StepResult.styl';

const b = cn('StepResult');

export class StepResult extends PureComponent {
    proceedToNextScreen = () => {
        const {nextStep, setNextStep, getUpdatedAccountInfo} = this.props;

        if (nextStep === STEPS.FINISH) {
            return getUpdatedAccountInfo();
        }

        setNextStep(nextStep);
    };

    render() {
        const {screenType, title, description, isNotMePage} = this.props;
        const buttonText = isNotMePage
            ? i18n('ProfileSecurity.profile.security.next-btn')
            : screenType === 'email'
            ? i18n('ProfileSecurity.security.step_final_btn')
            : i18n('ProfileSecurity.security.next_options_btn');

        return (
            <main className={b('container')}>
                <div className={b('header')}>
                    <div className={b('headerIcon', {icon: screenType})} role='presentation' aria-hidden='true'>
                        <div className={b('iconOk')} />
                    </div>
                </div>
                <div className={b('content')}>
                    <h2 className={b('title')}>{title}</h2>
                    <div className={b('description')}>
                        <p>{description}</p>
                    </div>
                </div>
                <div className={b('footer')}>
                    <Button size='l' view='action' type='button' onClick={this.proceedToNextScreen}>
                        {buttonText}
                    </Button>
                </div>
            </main>
        );
    }
}

StepResult.propTypes = {
    setNextStep: PropTypes.func.isRequired,
    getUpdatedAccountInfo: PropTypes.func.isRequired,
    prevStep: PropTypes.string.isRequired,
    nextStep: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
    description: PropTypes.string.isRequired,
    screenType: PropTypes.string.isRequired,
    isNotMePage: PropTypes.bool
};
