import {connect} from 'react-redux';
import {StepResult} from './StepResult.jsx';
import {STEPS} from '@blocks/Security/config';
import {setNextStep} from '../../actions/index';
import {getUpdatedAccountInfo} from '@blocks/Security/actions/getUpdatedAccountInfo';

const TEXTS_TO_STEP = {
    passwordForm: {
        title: i18n('ProfileSecurity.security.paswd_changed'),
        description: i18n('ProfileSecurity.security.step_update-text')
    },
    phone: {
        title: i18n('ProfileSecurity.security.phone_added'),
        description: i18n('ProfileSecurity.security.step_text')
    },
    phoneBind: {
        title: i18n('ProfileSecurity.security.phone_added'),
        description: i18n('ProfileSecurity.security.step_text')
    },
    phoneChange: {
        title: i18n('ProfileSecurity.security.phone_changed'),
        description: i18n('ProfileSecurity.security.step_text')
    },
    emailAdd: {
        title: i18n('ProfileSecurity.security.email_added'),
        description: i18n('ProfileSecurity.security.step_text')
    },
    emailEdit: {
        title: i18n('ProfileSecurity.security.email_updated'),
        description: i18n('ProfileSecurity.security.step_text')
    },
    notMe: {
        title: i18n('ProfileSecurity.security.paswd_changed'),
        description: i18n('ProfileSecurity.notme.change_pwd_result')
    }
};
const SCREEN_MAP_NEXT = {
    password: STEPS.PHONE,
    phone: STEPS.EMAIL,
    email: STEPS.FINISH,
    notMe: STEPS.FINISH
};

const mapStateToProps = (state = {}) => {
    const {securityInfo = {}} = state;
    const {prevStep, screenType, isNotMePage} = securityInfo;

    return {
        prevStep,
        nextStep: isNotMePage ? SCREEN_MAP_NEXT.notMe : SCREEN_MAP_NEXT[screenType],
        title: TEXTS_TO_STEP[prevStep].title,
        description: isNotMePage ? TEXTS_TO_STEP.notMe.description : TEXTS_TO_STEP[prevStep].description,
        screenType,
        isNotMePage
    };
};

const mapDispatchToProps = {
    setNextStep,
    getUpdatedAccountInfo
};

const ConnectedStepResult = connect(mapStateToProps, mapDispatchToProps)(StepResult);

export {ConnectedStepResult as StepResult};
