import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import {Link} from '@components/Link';
import metrika from '@blocks/metrics';

import './Welcome.styl';

const b = cn('Welcome');

export class Welcome extends PureComponent {
    componentDidMount() {
        const {securityLevel} = this.props;

        metrika.setHeader('Страница безопасности v2');
        metrika.send(`Показ стартового экрана, ${securityLevel === 'high' ? 'хороший' : 'плохой'} статус`);
    }

    proceedToNextScreen = () => {
        const {setNextStep, nextStep} = this.props;

        setNextStep(nextStep);
    };

    onSkip = () => {
        const {skipAdditionalData, additionalDataRequestTrackId} = this.props;

        skipAdditionalData('yes', additionalDataRequestTrackId);
    };

    render() {
        const {
            title,
            buttonText,
            description,
            securityLevel,
            is2faEnabled,
            isMobile,
            infoLink,
            profileUrl,
            isForced
        } = this.props;

        return (
            <main className={b('container')}>
                <div className={b('header')}>
                    <div className={b('header-icon')} role='presentation' aria-hidden='true'>
                        <div className={b('header-avatar')} />
                        <div className={b('shield', {securityLevel})} />
                    </div>
                </div>
                <div className={b('content')}>
                    <h2 className={b('title-large')}>{title}</h2>
                    <div className={b('description')}>
                        {!is2faEnabled && <p>{description}</p>}
                        <Link href={infoLink} pseudo={false}>
                            {i18n('ProfileSecurity.about.link')}
                        </Link>
                    </div>
                </div>
                <div className={b('footer')}>
                    {is2faEnabled ? (
                        <Button
                            dataT='welcome-start-2fa'
                            size='l'
                            width={isMobile ? 'max' : 'auto'}
                            view='action'
                            type='link'
                            url={profileUrl}
                        >
                            {i18n('ProfileSecurity.final_btn')}
                        </Button>
                    ) : (
                        <Button
                            dataT='welcome-start'
                            size='l'
                            width={isMobile ? 'max' : 'auto'}
                            view='action'
                            type='button'
                            onClick={this.proceedToNextScreen}
                        >
                            {buttonText}
                        </Button>
                    )}
                    {isForced && (
                        <Button
                            dataT='skip'
                            size='l'
                            width={isMobile ? 'max' : 'auto'}
                            view='clear'
                            onClick={this.onSkip}
                        >
                            {i18n('ProfileSecurity.skip_next.btn')}
                        </Button>
                    )}
                </div>
            </main>
        );
    }
}

Welcome.propTypes = {
    title: PropTypes.string.isRequired,
    buttonText: PropTypes.string.isRequired,
    description: PropTypes.string.isRequired,
    securityLevel: PropTypes.string.isRequired,
    nextStep: PropTypes.string.isRequired,
    profileUrl: PropTypes.string.isRequired,
    setNextStep: PropTypes.func.isRequired,
    infoLink: PropTypes.string,
    isMobile: PropTypes.bool,
    is2faEnabled: PropTypes.bool,
    isForced: PropTypes.bool,
    skipAdditionalData: PropTypes.func.isRequired,
    additionalDataRequestTrackId: PropTypes.string
};
