import {connect} from 'react-redux';
import {Welcome} from './Welcome.jsx';
import {setNextStep} from '../../actions/index';
import {STEPS} from '@blocks/Security/config';
import {isMobile} from '@blocks/selectors';
import skipAdditionalData from '@blocks/authv2/actions/skipAdditionalData';

const getTitle = (securityLevel) => {
    const levelMapTitle = {
        high: i18n('ProfileSecurity.security.high_level_title'),
        low: i18n('ProfileSecurity.security.low_level_title')
    };

    return levelMapTitle[securityLevel];
};
const getDescription = (securityLevel) => {
    const levelMapDescription = {
        high: i18n('ProfileSecurity.security.high_level_description'),
        low: i18n('ProfileSecurity.security.low_level_description')
    };

    return levelMapDescription[securityLevel];
};
const getButtonText = (securityLevel) =>
    securityLevel === 'high' ? i18n('ProfileSecurity.security.check-btn') : i18n('ProfileSecurity.protect_account.btn');

const mapStateToProps = (state = {}) => {
    const {securityInfo = {}, settings = {}, common = {}} = state;
    const {forced, defaultPage, additionalDataRequestTrackId} = common;
    const {securityLevel, is2faEnabled} = securityInfo;

    return {
        title: getTitle(securityLevel),
        description: getDescription(securityLevel),
        buttonText: getButtonText(securityLevel),
        securityLevel,
        is2faEnabled,
        nextStep: STEPS.PASSWORD,
        profileUrl: defaultPage,
        infoLink: `https://yandex.${settings.tld || 'ru'}/support/passport/security.html`,
        isMobile: isMobile(state),
        isForced: forced,
        additionalDataRequestTrackId
    };
};

const mapDispatchToProps = {
    setNextStep,
    skipAdditionalData
};

const ConnectedWelcome = connect(mapStateToProps, mapDispatchToProps)(Welcome);

export {ConnectedWelcome as Welcome};
