import {combineReducers} from 'redux';
import header from '@blocks/morda/components/header/reducers';
import common from '@blocks/common/reducers';
import form from '@blocks/reducers/form';
import domik from '@components/RequestDataDomik/reducers';
import captcha from '@components/Captcha/reducers';
import isLoading from '@blocks/reducers/spin';
import changePassword from '@blocks/reducers/changePassword';
import editEmails from '@blocks/reducers/editEmails';
import phoneProcess from '@blocks/reducers/phoneProcess';
import {SET_STEP, SET_PREV_STEP, SET_SCREEN_TYPE, UPDATE_ACCOUNT_INFO} from '../actions/';

const initialState = {
    step: 'welcome',
    isLoading: false
};
const stub = (state = {}) => state;
const rootReducer = combineReducers({
    common,
    header,
    person: stub,
    access: stub,
    settings: stub,
    customs: stub,
    footer: stub,
    dashboard: stub,
    metrics: stub,
    monitoring: stub,
    securityInfo,
    domik,
    captcha,
    form,
    changePassword,
    phoneProcess,
    editEmails,
    isLoading,
    tracks: stub
});

export default rootReducer;

function securityInfo(state = initialState, action = {}) {
    switch (action.type) {
        case SET_STEP: {
            return Object.assign({}, state, {
                step: action.step,
                prevStep: state.step !== 'email' ? state.step : state.prevStep
            });
        }
        case SET_PREV_STEP: {
            return Object.assign({}, state, {
                prevStep: action.step
            });
        }
        case SET_SCREEN_TYPE: {
            return Object.assign({}, state, {
                screenType: action.screenType
            });
        }
        case UPDATE_ACCOUNT_INFO: {
            return Object.assign({}, state, action.payload);
        }
        default:
            return state;
    }
}
