import {Welcome} from '@blocks/Security/components/Welcome';
import {Password} from '@blocks/Security/components/Password';
import {PasswordForm} from '@blocks/Security/components/PasswordForm';
import {Phone} from '@blocks/Security/components/Phone';
import {PhoneBind} from '@blocks/Security/components/Phone/PhoneBind';
import {PhoneChange} from '@blocks/Security/components/Phone/PhoneChange';
import {Email} from '@blocks/Security/components/Email';
import {EmailEdit} from '@blocks/Security/components/Email/EmailEdit';
import {EmailAdd} from '@blocks/Security/components/Email/EmailAdd';
import {EmailConfirm} from '@blocks/Security/components/Email/EmailConfirm';
import {StepResult} from '@blocks/Security/components/StepResult';
import {FinalScreen} from '@blocks/Security/components/FinalScreen';
import {InfoScreen} from '@blocks/Security/components/InfoScreen';
import {AuthInfo} from '@blocks/NotMe/AuthInfo';
import {STEPS} from '@blocks/Security/config';

export const STEP_SCREENS = {
    [STEPS.WELCOME]: Welcome,
    [STEPS.PASSWORD]: Password,
    [STEPS.PASSWORD_FORM]: PasswordForm,
    [STEPS.PHONE]: Phone,
    [STEPS.PHONE_BIND]: PhoneBind,
    [STEPS.PHONE_CHANGE]: PhoneChange,
    [STEPS.EMAIL]: Email,
    [STEPS.EMAIL_EDIT]: EmailEdit,
    [STEPS.EMAIL_ADD]: EmailAdd,
    [STEPS.EMAIL_CONFIRM]: EmailConfirm,
    [STEPS.STEP_RESULT]: StepResult,
    [STEPS.FINISH]: FinalScreen,
    [STEPS.INFO]: InfoScreen,
    [STEPS.AUTH_INFO]: AuthInfo
};
