import React from 'react';
import PropTypes from 'prop-types';
import {CheckCSSLoad} from '@components/CheckCSSLoad';
import {RegistrationWithSuggestToRestoreByPhone} from '@blocks/SignUp/modes/RegistrationWithSuggestToRestoreByPhone';
import {UserEntryFlow} from '@blocks/UserEntryFlow';
import api from '@blocks/api';
import Logger from '@old-blocks/logger/Logger';
import {
    MODE_SIMPLE,
    MODE_WITH_SUGGEST_TO_RESTORE_BY_PHONE,
    MODE_BROWSER,
    MODE_NEOPHONISH
} from '@blocks/SignUp/modes/constants';
import TestingTrackId from '@components/TestingTrackId/TestingTrackId';

class SignUp extends React.PureComponent {
    componentDidMount() {
        const {trackId, language, isDev} = this.props;

        if (trackId) {
            api.checkJSLoad({trackId, language});

            if (!isDev) {
                Logger.init({trackId});
            }
        }
    }

    componentDidUpdate(prevProps) {
        const {trackId, language, isDev} = this.props;

        if (trackId && prevProps.trackId !== trackId) {
            api.checkJSLoad({trackId, language});

            if (!isDev) {
                Logger.init({trackId});
            }
        }
    }

    componentWillUnmount() {
        const {isDev} = this.props;

        if (!isDev) {
            Logger.destroy();
        }
    }

    _getRegistrationForm = () => {
        const {mode} = this.props;

        switch (mode) {
            case MODE_BROWSER: {
                return <RegistrationWithSuggestToRestoreByPhone />;
            }

            case MODE_WITH_SUGGEST_TO_RESTORE_BY_PHONE:
            case MODE_NEOPHONISH:
            default: {
                return <UserEntryFlow />;
            }
        }
    };

    render() {
        const {trackId} = this.props;

        return (
            <React.Fragment>
                {this._getRegistrationForm()}
                <CheckCSSLoad />
                <TestingTrackId trackId={trackId} />
            </React.Fragment>
        );
    }
}

SignUp.propTypes = {
    mode: PropTypes.oneOf([MODE_WITH_SUGGEST_TO_RESTORE_BY_PHONE, MODE_BROWSER, MODE_NEOPHONISH, MODE_SIMPLE]),
    trackId: PropTypes.string.isRequired,
    language: PropTypes.string.isRequired,
    isDev: PropTypes.bool.isRequired
};

export {SignUp};
